% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISRaD.extra.delta_delta.R
\name{ISRaD.extra.delta_delta}
\alias{ISRaD.extra.delta_delta}
\title{ISRaD.extra.delta_delta}
\usage{
ISRaD.extra.delta_delta(database)
}
\arguments{
\item{database}{ISRaD dataset object}
}
\value{
ISRaD_data object with new delta-delta columns in relevant tables.
}
\description{
Calculates the difference between sample delta 14c and the atmosphere for the year of collection (delta-delta)
}
\details{
Creates new column for delta-delta value. Function "ISRaD.extra.calc_atm14c" should be run first.
}
\examples{
# Load example dataset Gaudinski_2001
database <- ISRaD::Gaudinski_2001
# Fill profile coordinates
database.x <- ISRaD.extra.fill_coords(database)
# Fill dates
database.x <- ISRaD.extra.fill_dates(database.x)
# Fill delta 14C from fraction modern
database.x <- ISRaD.extra.fill_rc(database.x)
# Fill atmospheric 14c
database.x <- ISRaD.extra.calc_atm14c(database.x)
# Fill delta delta
database.x <- ISRaD.extra.delta_delta(database.x)
}
\author{
J. Beem-Miller
}
