% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataSetList.R
\name{generate_data.ECDF}
\alias{generate_data.ECDF}
\title{Generate dataframe of a single function/dimension pair}
\usage{
generate_data.ECDF(dsList, targets, scale_log = F, which = "by_RT")
}
\arguments{
\item{dsList}{The DataSetList object}

\item{targets}{A list or data.table containing the targets per function / dimension. If this is 
a data.table, it needs columns 'target', 'DIM' and 'funcId'}

\item{scale_log}{Wheterh to use logarithmic scaling or not}

\item{which}{Whether to use a fixed-target 'by_RT' perspective or fixed-budget 'by_FV'}
}
\description{
This function generates a dataframe which can be easily plotted using the `plot_general_data`-function
}
\examples{
generate_data.ECDF(subset(dsl, funcId == 1), c(10, 15, 16))
}
