% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FullConditionals.R
\name{storeControl}
\alias{storeControl}
\title{Set storage values for use with the IMIFA family of models}
\usage{
storeControl(mu.switch = TRUE,
             score.switch = TRUE,
             load.switch = TRUE,
             psi.switch = TRUE,
             pi.switch = TRUE,
             ...)
}
\arguments{
\item{mu.switch}{Logical indicating whether the means are to be stored (defaults to \code{TRUE}).}

\item{score.switch}{Logical indicating whether the factor scores are to be stored.

As the array containing each sampled scores matrix tends to be amongst the largest objects to be stored, this defaults to \code{FALSE} inside \code{\link{mcmc_IMIFA}} when \code{length(range.G) * length(range.Q) > 10}, otherwise the default is \code{TRUE}. For the "\code{MIFA}", "\code{OMIFA}", and "\code{IMIFA}" methods, setting this switch to \code{FALSE} also offers a slight speed-up.}

\item{load.switch}{Logical indicating whether the factor loadings are to be stored (defaults to \code{TRUE}).}

\item{psi.switch}{Logical indicating whether the uniquenesses are to be stored (defaults to \code{TRUE}).}

\item{pi.switch}{Logical indicating whether the mixing proportions are to be stored (defaults to \code{TRUE}).}

\item{...}{Catches unused arguments.}
}
\value{
A named vector in which the names are the names of the storage switches and the values are logicals indicating whether that parameter is to be stored. The list also contains as an attribute a logical for each switch indicating whether it was actually supplied (\code{TRUE}) or the default was accepted (\code{FALSE}).
}
\description{
Supplies a list of values for logical switches indicating whether parameters of interest (means, scores, loadings, uniquenesses, and mixing proportions) should be stored when running models from the IMIFA family via \code{\link{mcmc_IMIFA}}. It may be useful not to store certain parameters if memory is an issue.
}
\details{
\code{\link{storeControl}} is provided for assigning values for IMIFA models within \code{\link{mcmc_IMIFA}}. It may be useful not to store certain parameters if memory is an issue (e.g. for large data sets or for a large number of MCMC iterations after burnin and thinning). Warning: posterior inference and plotting won't be posssible for parameters not stored. In particular, when loadings and uniquenesses are not stored (or when means are not stored, for any of the mixture models), it will not be possible to estimate covariance matrices and compute error metrics. If loadings are not stored but scores are, caution is advised when examining posterior scores as Procrustes rotation will not occur within \code{\link{get_IMIFA_results}}.
}
\note{
Further warning messages may appear when \code{\link{mcmc_IMIFA}} is called depending on the particularities of the data set and the IMIFA method employed etc. as additional checks occur.
}
\examples{
storeControl(score.switch=FALSE)

# data(olive)
# sim <- mcmc_IMIFA(olive, "IMIFA", n.iters=5000,
#                   storage=storeControl(score.switch=FALSE))

# Alternatively specify these arguments directly
# sim <- mcmc_IMIFA(olive, "IMIFA", n.iters=5000, score.switch=FALSE)
}
\seealso{
\code{\link{mcmc_IMIFA}}, \code{\link{get_IMIFA_results}}
}
\author{
Keefe Murphy - <\email{keefe.murphy@ucd.ie}>
}
\keyword{control}
