% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FullConditionals.R
\name{Ledermann}
\alias{Ledermann}
\title{Ledermann Bound}
\usage{
Ledermann(P)
}
\arguments{
\item{P}{Integer number of variables in data set. This argument is vectorized.}
}
\value{
The Ledermann bound, a non-negative integer, or a vector of \code{length(P)} such bounds.
}
\description{
Returns the maximum possible number of latent factors in a factor analysis model for data of dimension \code{P}. This Ledermann bound is given by the largest integer smaller than or equal to the solution \eqn{k}{k} of \eqn{(M - k)^2 \geq M + k}{(M - k)^2 >= M + k}.
}
\examples{
Ledermann(c(25, 50, 100))
}
\keyword{utility}
