% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lab.fqcs.R
\name{bootstrap.quantile}
\alias{bootstrap.quantile}
\alias{bootstrap.quantile.default}
\alias{bootstrap.quantile.lab.fqcd}
\alias{print.bootstrap.quantile}
\alias{summary.bootstrap.quantile}
\title{Compute functional (FDA) Mandel's h and k statistics}
\usage{
bootstrap.quantile(x, ...)

\method{bootstrap.quantile}{default}(x, argvals = NULL, rangeval = NULL,
  statistic = c("h", "k"), method = c("Walter", "Depth"), alpha = 0.05,
  quantile = 0.9, ball = FALSE, nb = 200, smo = 0, draw = TRUE,
  draw.control = NULL, x.co = NULL, y.co = NULL, legend = TRUE,
  col = NULL, ...)

\method{bootstrap.quantile}{lab.fqcd}(x, statistic = c("h", "k"),
  method = c("Walter", "Depth"), alpha = 0.05, quantile = 0.9,
  ball = FALSE, nb = 200, smo = 0, draw = TRUE, draw.control = NULL,
  x.co = NULL, y.co = NULL, legend = TRUE, col = NULL, ...)

\method{print}{bootstrap.quantile}(x, ...)

\method{summary}{bootstrap.quantile}(object, ...)
}
\arguments{
\item{x}{A \code{bootstrap.quantile} object for which a print is desired.}

\item{...}{Arguments passed to or from methods.}

\item{argvals}{Argvals, by default: 1:p.}

\item{rangeval}{Range of discretization points, by default: range(argvals).}

\item{statistic}{Sample statistic used for the interlaboratory analysis.
By default, it uses sample h.}

\item{method}{Quantile method used to estimate the critical quantile of the h and k statistics.}

\item{alpha}{Significance level.}

\item{quantile}{Probability with value in [0,1]}

\item{ball}{Logical argument. If draw = TRUE and ball = TRUE, i bootstrap curves and quantiles functions are plotted. 
They correspond to (1-alpha/2)*100 [\%]  most central  bootstrap resampling curves of q quantile. If draw = TRUE and ball = FALSE, 
the functional quantile q [\%] is determined.}

\item{nb}{Number of bootstrap resamples.}

\item{smo}{Smoothing parameter for the bootstrap resamples, defined as a proportion of the sample variance matrix.}

\item{draw}{Default TRUE, it plots the bootstrap samples and the h or k statistic.  It depends on the ball parameter.}

\item{draw.control}{List that specifies the col, lty and lwd plot arguments for the objects lab.fqcs, statistic, IN and OUT.}

\item{x.co}{It speficies the x co-ordinates to be used to place a legend.}

\item{y.co}{It specifies the y co-ordinates to be used to place a legend.}

\item{legend}{Logical argument. Default is TRUE then The legend default is used.}

\item{col}{Color specifications}

\item{object}{A \code{bootstrap.quantile} object for which a summary is desired.}
}
\description{
This function is used to compute functional (FDA)Mandel's h and k, statistics, 
required to perform Interlaboratory studies, and to detect non-consistent laboratories where data show a functional form (curve). In addition, 
bootstrap resampling methodology is used to estimate functional distributions. 
This allow to perform bootstrap confidence bands for FDA h and k statistics.
}
\examples{
\dontrun{
library(ILS)
data(TG)
delta <- seq(from = 40 ,to = 850 ,length.out = 1000 )
curves.fqcd <- lab.fqcd(TG, argvals = delta,rangeval = c(40,80))
draw.control = list(col = c("blue","grey"), 
                   lty = c(1, 1), lwd = c(2, 1))
#by Walter method
windows(20,10)
par(mfrow=c(1,2))
quantile95.w <- bootstrap.quantile(curves.fqcd, statistic = "h", 
                                  method = "Walter", smo = 0, 
                                  nb= 500, alpha = 0.05, quantile = 0.95,draw = TRUE,
                                  draw.control = draw.control,ylim=c(-3,3),x.co=50,y.co=3,
                                  main="Statistical h by the method's Walter")
}
}
\references{
\describe{
  \item{}{Febrero-Bande, M. and Oviedo, M. (2012),
   "Statistical computing in functional data analysis: the R package fda.usc". Journal of Statistical Software 51 (4), 1-28.}
  \item{}{Cuevas A., Febrero-Bande, M. and Fraiman, R. (2006), "On the use of the bootstrap for estimating functions with functional data". 
  Computational Statistics & Data Analysis 51, 2, 1063-1074. }
  \item{}{Naya, S., Tarrio-Saavedra. J., Lopez- Beceiro, J., Francisco Fernandez, M., Flores, M. and  Artiaga, R. (2014), 
  "Statistical functional approach for interlaboratory studies with thermal data". Journal of Thermal Analysis and Calorimetry, 118,1229-1243.}
  \item{}{Lopez-Pintado, S. and Romo, J. (2009), "On the concept of depth for functional data", 
  Journal of the American Statistical Association, 104, 486-503. }
  \item{}{Walter, S. (2011), Defining Quantiles for Functional Data: with an Application to the Reversal of Stock Price Decreases, 
  Department of Math. and Stat. The Uni. of Melbourne.}
}
}

