#' Obtaining indexes associated with the solution sources.
#'@description Function to estimate the total n of the S.S. (n), E.S., ks, c, ds, n.I.I.,
#'Sum.n.I.I., and percentage of I.I. (P.I.I.) by each S.S..
#'@usage SolutionSource(SolutionData,Production,EffectivenessOfSolution,Id,Verbose=TRUE)
#@param DataLoss It is an matrix object containing data from loss sources.
#'@param SolutionData It is an matrix object containing data from Solution sources.
#'@param Production Matrix with a column containing the damage or defoliation data.
#'@param EffectivenessOfSolution Output generated by the function  `EffectivenessOfSolution`
#'@param Id Logical vector indicating the lines of the `EffectivenessOfSolution` that are relevant.
#'Output generated by the function SelectEffectivenessOfSolution

#'@param Verbose Logical value (TRUE/FALSE). TRUE displays the results of the analysis.
#'@author Germano Leao Demolin-Leite (Instituto de Ciencias Agrarias da UFMG) \cr
#' Alcinei Mistico Azevedo (Instituto de Ciencias Agrarias da UFMG)




#'@return The function returns indices associated with the source of loss.
#'@importFrom stats lm
#'@export


#'@examples
#\dontrun{
#' data("DataLossSource")
#' ChisqTest_Distribution(DataLossSource)
#'
#' data("DataSolutionSource")
#' ChisqTest_Distribution(DataSolutionSource)
#'
#' data("DataDefoliation")
#' data("DataDamage")
#'
#' DataResult<-cbind(DataDefoliation,DataDamage$D.L.S.2,DataDefoliation,
#' DataDamage$D.L.S.4,DataDefoliation)
#' ResultLossSource<-LossSource(DataLoss = DataLossSource,DataResult =DataResult,
#' Cols=c(1,3,5),verbose=TRUE)
#'
#' EOS<-EffectivenessOfSolution(DataLossSource =DataLossSource,
#'                             DataSolutionSource =DataSolutionSource,
#'                             ResultLossSource = ResultLossSource)
#'
#' EOS
#' #Put: y and y
#' # ID<-SelectEffectivenessOfSolution(EOS)
#' ID<-c(FALSE,FALSE,FALSE,TRUE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,
#' FALSE,FALSE,FALSE,TRUE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE)

#' ResultSolutionSource<-SolutionSource(SolutionData =DataSolutionSource,Production =DataResult,
#'                                     EffectivenessOfSolution =EOS ,Id = ID,Verbose = TRUE  )
#' ResultSolutionSource
#'
#' # Put: y,n,y,n,y,n and y
#' # ReductionAbundance(ResultSolutionSource,ResultLossSource,
#' #                  EffectivenessOfSolution=EOS)
#'
#' ###################################################
#' EOSDamage<-EffectivenessOfSolution(DataLossSource =DataDamage,
#'                                   DataSolutionSource =DataSolutionSource,
#'                                   ResultLossSource = NULL)
#'
#'
#' EOSDamage
#'
#' # Put: y, n and y
#' #ReductionDamage(ResultSolutionSource,LossSource=DataDamage,
#' #                EffectivenessOfSolution=EOSDamage)
# }
#'





  SolutionSource=function(SolutionData,Production,
                          EffectivenessOfSolution,Id,Verbose=TRUE){

D2=SolutionData
Prod=Production
Es=EffectivenessOfSolution







  Esb=Es[Id,]


  n=colSums(D2)
  N=n[order(names(n))]

  c=colSums(D2>0)
  C=c[order(names(c))]

  x2=apply(D2,2, function(x) 1-suppressWarnings(chisq.test(x)$p.value))
  X2=x2[order(names(x2))]


  xx=cbind(colnames(D2),"",0)
  colnames(xx)=colnames(Esb)
  Esb=rbind(Esb,xx)

  E.S.=tapply(as.numeric(Esb[,3]),Esb[,1],sum)
  K.S.=E.S./N
  ds=X2

  n.I.I=K.S.*C*ds

  S.n.I.I=sum(n.I.I)

  P.I.I=100*n.I.I/S.n.I.I



 Res1=cbind(n=N,E.S.=E.S.,K.S.=K.S.,c=C,ds=ds,n.I.I=n.I.I,S.n.I.I=S.n.I.I,P.I.I=P.I.I)




   D=D2
   chisqq=apply(D,2, function(x) suppressWarnings(chisq.test(x)$p.value))

   Var=round(apply(D,2,var),4)
 Mean=round(apply(D,2,mean),4)
 p.Value=round(chisqq,4)


 Class.=NULL
 for(i in 1:length(p.Value)){
   p.V=p.Value[i]
   pv2=100*(p.V)
   class="Random"
   if(pv2<2.5){
     class="Aggregated"
   }

   if(pv2>97.5){
     class="Regular"
   }

   Class.=c(Class.,class)
 }



 Res2=data.frame(Var=Var,Mean=Mean,p.Value=p.Value,Aggregation=Class.)
 return(list(Res1=round(Res1,6),Res2=Res2))
}

