% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cpp_transform}
\alias{cpp_transform}
\title{Matrix Transformation}
\arguments{
\item{mat}{NumericMatrix.}

\item{color}{NumericVector, whose members are h,s,v color.
This vector has to be named with 1st name being the name of this color.}

\item{msk}{IntegerMatrix.}

\item{size}{a length 2 IntegerVector, of final dimensions (height,width) of the image. Default is 0,0 for no change.}

\item{mode}{string, color mode export. Either "rgb", "gray" or "raw". Default is "raw".}

\item{type}{uint16_t image object type.
Rcpp::Rf_rnorm(bg, sd) function is used. Default is true.}

\item{input_range}{a finite NumericVector, only apply when mode is not "raw", sets the range of the input intensity values. Default is c(0,4095).
values exceeding this range are clipped.}

\item{add_noise}{bool, if true adds normal noise.}

\item{bg}{double, mean value of the background added if add_noise is true. Default is 0.}

\item{sd}{double, standard deviation of the background added if add_noise is true. Default is 0.}

\item{full_range}{bool, only apply when mode is not "raw", if full_range is TRUE, then 'input_range' will be set to 'c(0,4095)' and gamma forced to 1. Default is false.}

\item{force_range}{bool, only apply when mode is not "raw", if force_range is TRUE, then 'input_range' will be adjusted to mat range in [-4095, +inf] and gamma forced to 1. Default is false.\cr
Note that this parameter takes the precedence over 'input_range' and 'full_range'.}

\item{gamma}{correction. Default is 1, for no correction.}

\item{spatialX}{X offset correction. Default is 0.0 for no change.}

\item{spatialY}{Y offset correction. Default is 0.0 for no change.}
}
\description{
Function to normalize, colorize and add background to images.
}
\details{
When add_noise is false, backgound will be automatically set to minimal pixel value for "masked" and "MC" removal method.\cr
when a mask is detected, add_noise, full_range and force_range are set to false, background mean and sd to 0, and input_range to [0,3].\cr
}
\keyword{internal}
