% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuneICRF.R
\name{tuneICRF}
\alias{tuneICRF}
\title{Tune mtry to the optimal value with respect to out-of-bag error for an ICcforest model}
\usage{
tuneICRF(formula, data, mtryStart = NULL, stepFactor = 1.5,
  ntreeTry = 100L, control = partykit::ctree_control(teststat = "quad",
  testtype = "Univ", mincriterion = 0, saveinfo = FALSE, minsplit =
  nrow(data) * 0.15, minbucket = nrow(data) * 0.06), suppress = TRUE,
  trace = TRUE, plot = FALSE, doBest = FALSE)
}
\arguments{
\item{formula}{a formula object, with the response being a \code{\link[survival]{Surv}} 
object, with form 


\code{Surv(time1, time2, type="interval2")}.}

\item{data}{a data frame containing the variables named in \code{Formula}.}

\item{mtryStart}{starting value of \code{mtry}; default is \code{sqrt(nvar)}.}

\item{stepFactor}{at each iteration, \code{mtry} is inflated (or deflated) by this value.}

\item{ntreeTry}{number of trees used at the tuning step.}

\item{control}{a list with control parameters, see \code{\link[partykit]{cforest}}. 
The default values correspond to those of the default values used by \code{\link{ICcforest}}.}

\item{suppress}{a logical specifying whether the messages from \code{\link[icenReg]{getFitEsts}} 
are suppressed. If \code{FALSE}, the messages are printed. \code{suppress = TRUE} is set by default.}

\item{trace}{whether to print the progress of the search. \code{trace = TRUE} is set by default.}

\item{plot}{whether to plot the out-of-bag error as a function of \code{mtry}.}

\item{doBest}{whether to run an ICcforest using the optimal mtry found.}

\item{...}{additional arguments.}
}
\value{
If \code{doBest=FALSE} (default), this returns the optimal mtry value of those searched.

If \code{doBest=TRUE}, this returns the ICcforest object produced with the optimal mtry.
}
\description{
Starting with the default value of mtry, search for the optimal value 
(with respect to Out-of-Bag error estimate) of mtry for ICcforest.
}
\examples{
### Example with dataset tandmob2
library(icenReg)
data(miceData)

## For ICcforest to run, Inf should be set to be a large number, for example, 9999999.
miceData$u[miceData$u == Inf] <- 9999999.

## Create a new variable to be selected from
miceData$new = rep(1:4)

## Tune mtry 
mtryTune <- tuneICRF(Surv(l, u, type = "interval2") ~ grp + new, data = miceData)

}
\seealso{
\code{\link{sbrier_IC}} for evaluation of model fit for interval-censored data 
when searching for the optimal value of \code{mtry}.
}
\keyword{brier}
\keyword{errors,}
\keyword{mtry,}
\keyword{out-of-bag}
\keyword{score}
