% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_related_functions.R
\name{VCFsToDBSCatalogs}
\alias{VCFsToDBSCatalogs}
\title{Create DBS catalogs from VCFs}
\usage{
VCFsToDBSCatalogs(
  list.of.DBS.vcfs,
  ref.genome,
  trans.ranges = NULL,
  region = "unknown"
)
}
\arguments{
\item{list.of.DBS.vcfs}{List of in-memory data frames of pure DBS mutations
-- no SBS or 3+BS mutations. The list names will be the sample ids in the
output catalog.}

\item{ref.genome}{A \code{ref.genome} argument as described in
\code{\link{ICAMS}}.}

\item{trans.ranges}{Optional. If \code{ref.genome} specifies one of the
\code{\link{BSgenome}} object 
\enumerate{
  \item \code{\link[BSgenome.Hsapiens.1000genomes.hs37d5]{BSgenome.Hsapiens.1000genomes.hs37d5}}
  \item \code{\link[BSgenome.Hsapiens.UCSC.hg38]{BSgenome.Hsapiens.UCSC.hg38}}
  \item \code{\link[BSgenome.Mmusculus.UCSC.mm10]{BSgenome.Mmusculus.UCSC.mm10}}
}
then the function will infer \code{trans.ranges} automatically. Otherwise,
user will need to provide the necessary \code{trans.ranges}. Please refer to
\code{\link{TranscriptRanges}} for more details.
If \code{is.null(trans.ranges)} do not add transcript range
information.}

\item{region}{A character string designating a genomic region;
see \code{\link{as.catalog}} and \code{\link{ICAMS}}.}
}
\value{
A list of 3 DBS catalogs, one each for 78, 144, 136: catDBS78
  catDBS144 catDBS136. If trans.ranges is not provided by user and cannot be
  inferred by ICAMS, DBS 144 catalog will not be generated. Each catalog has
  attributes added. See \code{\link{as.catalog}} for more details.
}
\description{
Create a list of 3 catalogs (one each for DBS78, DBS144 and DBS136)
out of the contents in list.of.DBS.vcfs. The VCFs must not contain
any type of mutation other then DBSs.
}
\note{
DBS 144 catalog only contains mutations in transcribed regions.
}
\section{Comments}{

To add or change attributes of the catalog, you can use function
\code{\link[base]{attr}}. \cr For example, \code{attr(catalog, "abundance")
<- custom.abundance}.
}

\examples{
file <- c(system.file("extdata/Mutect-vcf",
                      "Mutect.GRCh37.s1.vcf",
                      package = "ICAMS"))
list.of.DBS.vcfs <- ReadAndSplitMutectVCFs(file)$DBS
if (requireNamespace("BSgenome.Hsapiens.1000genomes.hs37d5", quietly = TRUE)) {
  catalogs.DBS <- VCFsToDBSCatalogs(list.of.DBS.vcfs, ref.genome = "hg19",
                                    trans.ranges = trans.ranges.GRCh37,
                                    region = "genome")}
}
