% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fooTp.R
\name{wTp}
\alias{wTp}
\title{Speed of Sound, Function of Temperature and Pressure}
\usage{
wTp(T, p)
}
\arguments{
\item{T}{Temperature [ K ]}

\item{p}{Pressure [ MPa ]}
}
\value{
The Speed of Sound: w [ m s-1 ] and an 
    (if an error occur: \link{errorCodes})
}
\description{
The function \code{wTp(T,p)} returns the Speed of Sound, [ m s-1 ], 
     for given T [K] and D [kg/m3].
}
\details{
This function calls a Fortran DLL that solves the Helmholtz Energy Equation. 
    in accordance with the Revised Release on the IAPWS Formulation 1995 for the 
    Thermodynamic Properties of Ordinary Water Substance for General and Scientific
    Use (June 2014) developed by the International Association for the Properties of
    Water and Steam,  \url{http://www.iapws.org/relguide/IAPWS-95.html}. It is valid  
    from the triple point to the pressure of 1000 MPa and temperature of 1273.
}
\examples{
T <- 500.
p <- 10.0003858
wTp(T,p)

}

