\name{fit.hyperb}

\alias{fit.hyperb}

\title{Fit the Hyperbolic Distribution to Data}
\description{
    Fits a hyperbolic distribution to data.  
    Displays the histogram, log-histogram (both with fitted densities)
    and qqplot for the fit which has the maximum likelihood.
}

\usage{
    fit.hyperb(x, freq = NULL, breaks = NULL, theta.start = NULL, 
      start.values = c("all"), method = c("BFGS"), max.lh = FALSE, 
      plots = TRUE, leave.on = FALSE, controlbfgs = list(maxit = 100), 
      controlnm = list(maxit = 1000), maxitnlm = 1500, ...)
}

\arguments{
  \item{x}{data vector}
  \item{freq}{a vector of weights with length equal to \code{length(x)}}
  \item{breaks}{breaks for histogram, defaults to those generated by 
    \code{hist(x,right=F,plot=F)}}
  \item{theta.start}{a user specified starting parameter vector taking 
    the form \code{c(pi,zeta,delta,mu)}}
  \item{start.values}{vector of the different starting values to consider.  
    See \bold{Details}}
  \item{method}{vector of the different optimisation methods to consider.  
    See \bold{Details}}
  \item{max.lh}{logical; if \code{TRUE}, function only outputs for the 
    \code{start.values}/\code{method} combination that results in the highest 
    likelihood}
  \item{plots}{logical; if \code{FALSE} suppresses printing of the histogram, 
    log-histogram and qqplot}
  \item{leave.on}{for use with plotting devices.  When \code{TRUE} does not 
    close off the plotting device (eg. \code{postscript}) after writing the 
    3 plots}
  \item{controlbfgs}{a list of control parameters for \code{optim} when using 
    the \code{"BFGS"} optimisation}
  \item{controlnm}{a list of control parameters for \code{optim}
    when using the \code{"Nelder-Mead"} optimisation}
  \item{maxitnlm}{a positive integer specifying the maximum number of
    iterations when using the \code{"nlm"} optimisation}
  \item{\dots}{passes arguments to \code{par}, \code{hist}, \code{log.hist} 
    and \code{qqplot}}
}
\details{
  Entries in the start.values vector are from the following:
  \itemize{
    \item{\code{"bn"}}{based on Barndorff-Nielsen (1977)}
    \item{\code{"fn"}}{a fitted normal distribution}
    \item{\code{"sl"}}{based on a fitted skew-Laplace distribution}
    \item{\code{"us"}}{specified by the user}
  }
The three optimisation methods currently available are:
\itemize{
\item{\code{"BFGS"}}{uses the quasi-Newton method \code{"BFGS"} as documented 
    in \code{optim}}
\item{\code{"Nelder-Mead"}}{uses an implementation of the Nelder and Mead 
    method as documented in \code{optim}}
\item{\code{"nlm"}}{uses the \code{nlm} function in R}
}

}
\value{
  A list with components
    \item{pars}{a dataframe displaying the results of maximisation.  
      Consists of columns for \code{pi}, \code{zeta}, \code{delta}, \code{mu}, 
      \code{LogLikelihood}, \code{Convergence} and \code{Iterations}.  
      See the relevant documentation (either \code{optim} or \code{nlm}) 
      for details on convergence}
  \item{breaks}{the breaks used}
  \item{starting.values}{a dataframe displaying the various starting values 
    considered}
}

\references{
  Barndorff-Nielsen, O. (1977)
  Exponentially decreasing distributions for the logarithm of particle size,
  \emph{Proc. Roy. Soc. Lond.},
  A\bold{353}, 401--419.
  
  Fieller, N. J., Flenley, E. C. and Olbricht, W. (1992)
  Statistics of particle size data.
  \emph{Appl. Statist.},
  \bold{41}, 127--146.

}

\author{David Scott \email{d.scott@auckland.ac.nz}, 
  Ai-Wei Lee, Jennifer Tso, Richard Trendall}


\seealso{
  \code{\link{optim}}, \code{\link{nlm}}, \code{\link{par}},
  \code{\link{hist}}, \code{\link{log.hist}}, \code{\link{qqplot}}
  and \code{\link{dskewlap}}
}

\examples{
theta <- c(2,2,2,2)
data.vector <- rhyperb(500,theta)
## See how well fit.hyperb works
fit.hyperb(data.vector)


## Use nlm instead of default
fit.hyperb(data.vector,method="nlm")


}

\keyword{distribution}
