% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimation_ML.R
\name{GetEstimate_ML}
\alias{GetEstimate_ML}
\title{Maximum-likelihood estimate of a distribution}
\usage{
GetEstimate_ML(
  y,
  dist,
  par0 = NULL,
  method = optim_method_def,
  lower = -Inf,
  upper = Inf
)
}
\arguments{
\item{y}{numeric vector, data}

\item{dist}{character, distribution name}

\item{par0}{numeric vector, initial parameter guess. You may use GetEstimate_ROUGH().}

\item{method}{character, method used to maximize likelihood, see ?optim}

\item{lower}{numeric vector, lower bounds, see ?optim}

\item{upper}{numeric vector, upper bounds, see ?optim}
}
\value{
A list with the following components:
    \item{par}{numeric vector, estimated parameter vector.}
    \item{obj}{numeric, objective fonction (maximum log-likelihood)}
    \item{ok}{logical, did computation succeed?}
    \item{err}{integer, error code (0 if ok)}
    \item{message}{error message}
}
\description{
Returns an estimate of a distribution using the method of maximum likelihood.
}
\examples{
y=c(9.2,9.5,11.4,9.5,9.4,9.6,10.5,11.1,10.5,10.4)
GetEstimate_ML(y,'Normal')
GetEstimate_ML(y,'LogNormal')
GetEstimate_ML(y,'Gumbel')
GetEstimate_ML(y,'Gumbel',par0=GetEstimate_ROUGH(y,'Gumbel')$par)
GetEstimate_ML(y,'GEV',par0=GetEstimate_ROUGH(y,'GEV')$par)
GetEstimate_ML(y,'Poisson')
}
