% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ellipseParam.R
\name{ellipseParam}
\alias{ellipseParam}
\title{Lengths Of The Semi-Axes Of Hotelling Ellipse}
\usage{
ellipseParam(data, k = 2, pcx = 1, pcy = 2)
}
\arguments{
\item{data}{Data frame or tibble of PCA, PLS, or ICA scores, or from other feature projection methods.}

\item{k}{Integer specifying the number of components (by default 2).}

\item{pcx}{Integer specifying which component is on the x-axis (by default 1).}

\item{pcy}{Integer specifying which component is on the y-axis (by default 2).}
}
\value{
Returns a list that includes:
\enumerate{
\item \strong{Tsquare} Data frame containing the T-squared statistic.
\item \strong{Ellipse} Data frame containing the lengths of the semi-minor and semi-major axes.
\item \strong{cutoff.99pct} Number corresponding to the T-square cutoff at 99\% confidence level.
\item \strong{cutoff.95pct} Number corresponding to the T-square cutoff at 95\% confidence level.
}
}
\description{
Compute the lengths of the semi-axes of Hotelling ellipse.
}
\examples{
## Principal components analysis (PCA)
library(dplyr)
set.seed(123)
pca_mod <- specData \%>\%
  dplyr::select(where(is.numeric)) \%>\%
  FactoMineR::PCA(scale.unit = FALSE, graph = FALSE)

## Extract PCA scores
pca_scores <- pca_mod \%>\%
   purrr::pluck("ind", "coord") \%>\%
   tibble::as_tibble()

## Get Hotelling T2-value and the lengths of the ellipse semi-axes
library(HotellingEllipse)
T2 <- ellipseParam(data = pca_scores, k = 2, pcx = 1, pcy = 2)

}
\author{
Christian L. Goueguel,
christian.goueguel@gmail.com
}
