% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ellipseCoord.R
\name{ellipseCoord}
\alias{ellipseCoord}
\title{Coordinate Points Of Hotelling Ellipse}
\usage{
ellipseCoord(data, pcx = 1, pcy = 2, conf.limit = 0.95, pts = 200)
}
\arguments{
\item{data}{a data frame or tibble of PCA/PLS scores}

\item{pcx}{an integer specifying which component is on the x-axis (by default 1)}

\item{pcy}{an integer specifying which component is on the y-axis (by default 2)}

\item{conf.limit}{an integer specifying the confidence level (by default 0.95)}

\item{pts}{an integer indicating the number of points of Hotelling ellipse (by default 200)}
}
\value{
a data frame with x and y coordinates
}
\description{
Get the x and y coordinates of Hotelling ellipse.
}
\examples{
## Principal components analysis (PCA)
library(dplyr)
set.seed(123)
pca_mod <- specData \%>\%
  dplyr::select(where(is.numeric)) \%>\%
  FactoMineR::PCA(scale.unit = FALSE, graph = FALSE)

## Extract PCA scores
pca_scores <- pca_mod \%>\%
   purrr::pluck("ind", "coord") \%>\%
   tibble::as_tibble()

## Get Hotelling ellipse coordinate points
library(HotellingEllipse)
xy_coord <- ellipseCoord(data = pca_scores, pcx = 1, pcy = 2, conf.limit = 0.95, pts = 200)

}
\author{
Christian L. Goueguel,
christian.goueguel@gmail.com
}
