% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utility.R
\name{data2hist}
\alias{data2hist}
\title{From real data to distributionH.}
\usage{
data2hist(data, algo = "histogram", type = "combined", qua = 10,
  breaks = numeric(0), epsilon = 0.01)
}
\arguments{
\item{data}{a set of numeric values.}

\item{algo}{(optional) a string. Default is "histogram", i.e. the function "histogram"
defined in the \code{\link[histogram]{histogram}}  package. \cr If "base" 
the \code{\link[graphics]{hist}} function is used. \cr
"FixedQuantiles" computes the histogram using as breaks a fixed number of quantiles.\cr
"ManualBreaks" computes a histogram where braks are provided as a vector of values.\cr
"PolyLine" computes a histogram using a piecewise linear approximation of the empirical
cumulative distribution function using the "Ramer-Douglas-Peucker algorithm", 
 \url{http://en.wikipedia.org/wiki/Ramer-Douglas-Peucker_algorithm}. 
 An \code{epsilon} parameter is required.
 The data are scaled in order to have a standard deviation equal to one.}

\item{type}{(optional) a string. Default is "combined" and generates 
a histogram having regularly spaced breaks (i.e., equi-width bins) and 
irregularly spaced ones. The choice is done accordingly with the penalization method described in 
\code{\link[histogram]{histogram}}. "regular" returns equi-width binned histograms, "irregular" returns
a histogram without equi-width histograms.}

\item{qua}{a positive integer to provide if \code{algo="FixedQuantiles"} is chosen. Default=10.}

\item{breaks}{a vector of values to provide if  \code{algo="ManualBreaks"} is chosen.}

\item{epsilon}{a number between 0 and 1 to provide if \code{algo="PolyLine"} is chosen. Default=0.01.}
}
\value{
A \code{distributionH} object, i.e. a distribution.
}
\description{
From real data to distributionH.
}
\examples{
data=rnorm(n = 1000,mean = 2,sd = 3)
mydist=data2hist(data)
plot(mydist)
}
\seealso{
\code{\link[histogram]{histogram}} function
}
