% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalcTheoreticalMDV.R
\name{CalcTheoreticalMDV}
\alias{CalcTheoreticalMDV}
\title{CalcTheoreticalMDV.}
\usage{
CalcTheoreticalMDV(fml = NULL)
}
\arguments{
\item{fml}{The chemical formula of the compound.}
}
\value{
A matrix with dimensions according to the attributes of \code{fml} or the number of carbons respectively.
}
\description{
\code{CalcTheoreticalMDV} will compute the Mass Distribution Vectors of isotopologues as it is used for correction matrix in \code{\link{CalcMID}} computations.
}
\details{
\code{CalcTheoreticalMDV} basically is a convenience function using Rdisop to generate the isotopologue distribution at natural abundance of 13C for a given formula.
It will break this down into a matrix where the components of the MID constitute the rows and the expected relative ion intensities are within the columns.
The number of exported ion intensities and MID components can be limited if numeric values for "nmz" and/or "nbio" provided as attributes with the formula.
}
\examples{
# standard distribution matrix
fml <- "C5H6Si1"
CalcTheoreticalMDV(fml=fml)
attr(fml,"nmz") <- 4
CalcTheoreticalMDV(fml=fml)
attr(fml,"nbio") <- 2
CalcTheoreticalMDV(fml=fml)
}
