% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sd_from_min_max.R
\name{sd_from_min_max}
\alias{sd_from_min_max}
\title{Distribution from minimum and maximum}
\usage{
sd_from_min_max(
  n,
  observedMean = NULL,
  observedMinimum,
  observedMaximum,
  priors = NULL,
  fittedparameters = c("mean-sd"),
  n.iter = 10000,
  n.chains = 1,
  n.adapt = 100,
  thin = 30,
  adaptive = FALSE,
  trace = 100
)
}
\arguments{
\item{n}{Number of observations used to estimate observedMinimum and observedMaximum}

\item{observedMean}{The observed mean (can be omited)}

\item{observedMinimum}{The observed minimum}

\item{observedMaximum}{The observed maximum}

\item{priors}{The priors (can be omited)}

\item{fittedparameters}{Can be "sd" or "mean-sd"}

\item{n.iter}{Number of iterations for each chain}

\item{n.chains}{Number of chains}

\item{n.adapt}{Number of iteration to stabilize likelihood}

\item{thin}{Interval for thinning likelihoods}

\item{adaptive}{Should an adaptive process for SDProp be used}

\item{trace}{Or FALSE or period to show progress}
}
\value{
sd_from_min_max returns a mcmcComposite object
}
\description{
Bayesian estimate of underlying distribution.\cr
The distribution of extrema is expected to be a Gaussian distribution; we could do better using
generalized extreme value (GEV) distribution.\cr
Weisstein, Eric W. "Extreme value distribution". mathworld.wolfram.com
}
\details{
sd_from_min_max returns standard deviation and/or mean from minimum and maximum
}
\examples{
\dontrun{
minobs <- 45
maxobs <- 53
n <- 4
# To estimate only the sd of the distribution
out_sd_mcmc <- sd_from_min_max(n=n, observedMinimum=minobs, 
                           observedMaximum=maxobs, 
                           fittedparameters="sd")
plot(out_sd_mcmc, what="MarkovChain", parameters="sd")
plot(out_sd_mcmc, what="posterior", parameters="sd")
as.parameters(out_sd_mcmc, index="quantile")
# To be compared with the rule of thumb:
print(paste0("sd = ", as.character((maxobs - minobs) / 4))) # SD Clearly biased

# To estimate both the sd and mean of the distribution

out_sd_mean_mcmc <- sd_from_min_max(n=n, observedMinimum=minobs, 
                           observedMaximum=maxobs, 
                           fittedparameters="mean-sd")

plot(out_sd_mean_mcmc, what="MarkovChain", parameters="sd")
plot(out_sd_mean_mcmc, what="MarkovChain", parameters="mean")
plot(out_sd_mean_mcmc, what="posterior", parameters="mean", xlim=c(0, 100), 
     breaks=seq(from=0, to=100, by=5))
as.parameters(out_sd_mean_mcmc, index="quantile")
# To be compared with the rule of thumb:
print(paste0("mean = ", as.character((maxobs + minobs) / 2))) # Mean Not so bad
print(paste0("sd = ", as.character((maxobs - minobs) / 4))) # SD Clearly biased

# Covariation of sd and mean is nearly NULL
cor(x=as.parameters(out_sd_mean_mcmc, index="all")[, "mean"], 
    y=as.parameters(out_sd_mean_mcmc, index="all")[, "sd"])^2
plot(x=as.parameters(out_sd_mean_mcmc, index="all")[, "mean"], 
     y=as.parameters(out_sd_mean_mcmc, index="all")[, "sd"], 
     xlab="mean", ylab="sd")


}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
