% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motifMatch.R
\name{motifMatch}
\alias{motifMatch}
\title{Identify Alleles that Share a Sequence Motif}
\usage{
motifMatch(motif, alignType, full = TRUE)
}
\arguments{
\item{motif}{A character string identifying a sequence variant motif in the following format: Locus*#$~#$~#$, where ## identifies a variant position, and $ identifies the sequence variant. Both nucleotide and peptide motifs can be provided, and any number of variants can be specified.}

\item{alignType}{A character string identifying the type of alignment being searched. Allowed values are "codon","gen", nuc" and "prot". Only one 'alignType' value is allowed.}

\item{full}{A logical value that specifies if full (TRUE) or truncated (FALSE) allele names should be returned.}
}
\value{
A character vector of allele names that contain the motif, or NA when no alleles contain the motif, NULL when no alignment is available for specified locus, and FALSE when the locus or motif is invalid.
}
\description{
Searches alignments for alleles that share a specific sequence motif.
}
\note{
This function requires an HLAalignments object that has been populated with alignments via alignmentFull().
}
