% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_significant_peptides.R
\name{plot_peptide_sig_tp}
\alias{plot_peptide_sig_tp}
\title{Significant peptide plots.}
\usage{
plot_peptide_sig_tp(
  df1,
  replicates = 3,
  nb_pep_row = 100,
  ranges = c(-Inf, seq(-30, 30, by = 10), Inf),
  pv_cutoff = 0.01
)
}
\arguments{
\item{df1}{average data frame. Generated using ave_timepoint() function.}

\item{replicates}{number of replicates in sample. Default set to 3.}

\item{nb_pep_row}{number of peptides in each row. Plotting parameter. Default set to 100.}

\item{ranges}{ranges for coloring scheme. Default set to c(-Inf, seq(-30, 30, by=10), Inf)}

\item{pv_cutoff}{p-value cutoff here set up to 0.01}
}
\value{
plot with peptides which are significantly different between sets.
}
\description{
Returns plot where significant peptides are colored in blue-red scheme.
}
