% Generated by roxygen2 (4.0.2): do not edit by hand
\name{computeCoefficients}
\alias{computeCoefficients}
\title{Compute coefficients}
\usage{
computeCoefficients(x, lambda, mode = "fraction")
}
\arguments{
\item{x}{a LarsParth object}

\item{lambda}{If mode ="norm", lambda represents the l1-norm of the coefficients with which we want to predict. If mode="fraction", lambda represents the ratio (l1-norm of the coefficientswith which we want to predict)/(l1-norm maximal of the LarsPath object).}

\item{mode}{"fraction" or "norm" or "lambda".}
}
\value{
A list containing
\describe{
  \item{variable}{Index of non-zeros coefficients.}
  \item{coefficient}{non-zeros coefficients.}
}
}
\description{
Compute coefficients at a given level of penalty
}
\examples{
dataset=simul(50,10000,0.4,10,50,matrix(c(0.1,0.8,0.02,0.02),nrow=2))
result=HDlars(dataset$data[1:40,],dataset$response[1:40])
coeff=computeCoefficients(result,0.3,"fraction")
}
\author{
Quentin Grimonprez
}

