% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{process_export_report}
\alias{process_export_report}
\title{Process and Export Report (Internal)}
\usage{
process_export_report(data, output_path, prefix = "", data_name = "data")
}
\arguments{
\item{data}{A structured SL4 or HAR object or a nested list of data frames.}

\item{output_path}{A character string specifying the output directory or file path.}

\item{prefix}{A character string to prepend to the exported filenames.}
}
\description{
Generates a summary report of variables and their corresponding output files
from structured SL4 or HAR data. The report is saved as an Excel file.
}
\details{
\itemize{
\item Extracts unique variable names and their associated export filenames.
\item Handles nested list structures by recursively traversing them.
\item The output report is saved as an Excel file named \code{"Report_<data_name>.xlsx"}.
}
}
\seealso{
\code{\link{export_data}}
}
\author{
Pattawee Puangchit
}
\keyword{internal}
