package de.fhg.iais.kd.gridr.interfaces;

import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;


public class FTPUpload {

	/**
	 * @param args
	 * args[0] url of the file to upload
	 * args[1] path where to upload that file, must not exist
	 */
	public static void main(String[] args) {
		
		if(args.length<2){
			System.err.println("wrong input arguments, usage: url, file");
			return;
		}
		URL url=null;
		try {
			url = new URL(args[0]);
		} catch (MalformedURLException e1) {
			System.err.println("Error: Path dont exists");
		}
		File localFile= new File(args[1]);
		
		if(!localFile.exists()){
			System.err.println("local file does not exists, stopping download");
			return;
		}
		
		URLConnection urlc;
		try{
			urlc = url.openConnection();
			OutputStream os = urlc.getOutputStream();
	
			FileInputStream is = new FileInputStream(localFile);
			byte[] buf = new byte[16384];
			int c;
			while (true) {
				c = is.read(buf);
				if (c <= 0)
					break;
				os.write(buf, 0, c);
			}
			os.close();
			is.close();
			urlc = null;
		}
		catch(Exception e){
			System.err.println("Error, cannot upload File: ");
			e.printStackTrace();
		}
	}

}
