% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ghfd_get_HF_data.R
\name{ghfd_get_HF_data}
\alias{ghfd_get_HF_data}
\title{Downloads and aggregates high frequency trading data directly from the Bovespa ftp}
\usage{
ghfd_get_HF_data(my.assets, type.market, first.date, last.date,
  first.time = "10:00:00", last.time = "17:00:00", type.output = "agg",
  agg.diff = "15 min", dl.dir = "ftp files", max.dl.tries = 10,
  clean.files = FALSE)
}
\arguments{
\item{my.assets}{The tickers (symbols) of the derised assets to import data (e.g. c('PETR4', 'VALE5'))}

\item{type.market}{The type of market to download data from ('equity', 'options', 'BMF' )}

\item{first.date}{The first date of the imported data (Date class)}

\item{last.date}{The last date of the imported data (Date class)}

\item{first.time}{The first intraday period to import the data. All trades before this time of day are ignored. As character, e.g. '10:00:00'.}

\item{last.time}{The last intraday period to import the data. All trades after this time of day are ignored. As character, e.g. '18:00:00'.}

\item{type.output}{Defines the type of output of the data. The choice 'agg' outputs aggregated data for time intervals defined in agg.diff.
The choice 'raw' outputs the raw, tick by tick, data from the zip files.}

\item{agg.diff}{The time interval used in the aggregation of data. Only used for type.output='agg'. It should contain a integer followed by a time unit ('sec' or 'secs', 'min' or 'mins', 'hour' or 'hours', 'day' or 'days').
Example: agg.diff = '15 mins', agg.diff = '1 hour'.}

\item{dl.dir}{The folder to download the zip files}

\item{max.dl.tries}{Maximum attempts to download the files from ftp}

\item{clean.files}{Should the files be removed after reading it? (TRUE or FALSE)}
}
\value{
A dataframe with the financial data (raw (tick by tick) or aggregated)
}
\description{
This function downloads zip files containing trades from Bovespa's ftp (ftp://ftp.bmf.com.br/MarketData/) and imports it into R.
See the vignette and examples for more details on how to use the function.
}
\examples{

my.assets <- 'ABEVA69'
type.market <- 'options'
first.date <- as.Date('2015-12-29')
last.date <- as.Date('2015-12-29')

\dontrun{
df.out <- ghfd_get_HF_data(my.assets, type.market, first.date,  last.date)
}
}

