% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdfpd_read_fre_zip_file.R
\name{gdfpd.read.fre.zip.file}
\alias{gdfpd.read.fre.zip.file}
\title{Reads a single FRE zip file downloaded from Bovespa}
\usage{
gdfpd.read.fre.zip.file(my.zip.file, folder.to.unzip = tempdir())
}
\arguments{
\item{my.zip.file}{Full path to zip file}

\item{folder.to.unzip}{Folder to unzip files (default = tempdir())}
}
\value{
A list with several dataframes containing financial statements
}
\description{
Reads a single FRE zip file downloaded from Bovespa
}
\examples{

my.f <- system.file('extdata/FRE_6629_HERC_2010-12-31.zip', package = 'GetDFPData')

my.l <- gdfpd.read.fre.zip.file(my.f)
print(my.l)

}
