% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Geodis.R
\name{geodis}
\alias{geodis}
\title{Reduction of the horizontal distance to the Ellipsoid.}
\usage{
geodis(Data_fm, digits = 4)
}
\arguments{
\item{Data_fm}{Point name, Ellipsoidal height and Horizontal distance as dataframe.}

\item{digits}{Number of digits the seconds are \code{\link{round}ed} to. DEFAULT: 4}
}
\value{
data.frame with the data in the following order: "Pt", "Kh(h)", "GEODESIC DISTANCE".
}
\description{
With this function it is possible to perform a reduction of the horizontal distance to the Ellipsoid.
}
\examples{
# Point name
Pto <- "St1"

# Ellipsoidal height
h <- 2500

# Horizontal distance
Dhz <- 728.5

# Ellipsoidal height and Horizontal distance as data.frame
Ellips_Horzdist_df <- data.frame(Pto, h, Dhz)

value <- geodis(Ellips_Horzdist_df, digits = 4)
print(value)
}
