% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LongLatToUTM.R
\name{LongLatToUTM}
\alias{LongLatToUTM}
\title{To convert from Geographic coordinate to UTM coordinate.}
\usage{
LongLatToUTM(longlat_df, crs = 4326, units = "m", digits = 4)
}
\arguments{
\item{longlat_df}{Point name, Sexagesimal longitude and latitude as dataframe.}

\item{crs}{EPGS number of the new coordinate reference system to transform. DEFAULT: 4326 (WGS84)}

\item{units}{Select units for UTM to work. DEFAULT: 'm'}

\item{digits}{Number of digits the seconds are \code{\link{round}ed} to. DEFAULT: 4}
}
\value{
a list with a data.frame and leaflet map.
}
\description{
With this function it is possible to convert from Geographic coordinate to UTM coordinate. It is also possible to convert from other coordinate reference systems by selecting their EPGS number to UTM coordinate. Review notes and references.
}
\note{
create data frame of epsg codes by epsg <- rgdal::make_EPSG()
}
\examples{
# Point name
Pto <- "St1"

# Longitude
g <- -71
m <- 18
s <- 44.86475

# Value in sexagesimal
sexa_long <- sexagesimal(g, m, s)

# Latitude
g1 <- -33
m1 <- 12
s1 <- 27.11457

# Value in sexagesimal
sexa_lat <- sexagesimal(g1, m1, s1)

# Longitude and Latitude as data.frame
longlat_df <- data.frame(Pto,sexa_long,sexa_lat)

value <- LongLatToUTM(longlat_df, crs = 4326, units = 'm', digits = 4)
print(value)
}
\references{
https://github.com/OSGeo/PROJ & https://github.com/cran/rgdal
}
\seealso{
\code{data.frame}
}
