% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covMatern.R
\name{covMatern}
\alias{covMatern}
\title{Creates a Matern covariance matrix.}
\usage{
covMatern(dMat = NULL, range = NULL, stdDev = NULL)
}
\arguments{
\item{dMat}{A distance matrix between the locations.}

\item{range}{Spatial range in kilometers.}

\item{stdDev}{The marginal variance.}
}
\value{
Matern covariance matrix.
}
\description{
Creates a Matern covariance matrix.
}
\examples{
if(requireNamespace("INLA")){
path1 <- system.file("extdata", "geoData.rda", package = "GeoAdjust")
load(path1)
loc <- cbind(surveyData$east, surveyData$north)
space.range <- 114
space.sigma <- 1
covMat <- covMatern(dMat = as.matrix(dist(loc)),
range = space.range, stdDev = space.sigma)
}
}
