% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importGTF.R
\name{importGTF}
\alias{importGTF}
\title{Import a GTF File}
\usage{
importGTF(file, skip = "auto", nrow = -1, use.data.table = TRUE,
  level = "gene", features = NULL, num.features = c("FPKM", "TPM"),
  print.features = FALSE, merge.feature = NULL, merge.all = TRUE,
  class.names = NULL, verbose = TRUE)
}
\arguments{
\item{file}{file or folder}

\item{skip}{numeric, lines to skip}

\item{nrow}{numeric, lines to read}

\item{use.data.table}{logical}

\item{level}{Character, read level, default: "gene"}

\item{features}{features to import}

\item{num.features}{names of the numeric features}

\item{print.features}{Logical, print available features}

\item{merge.feature}{Character, merge multiple samples to dataset}

\item{merge.all}{Logial, shall all samples be merged}

\item{class.names}{Vector with class names}

\item{verbose}{Logical, verbose function output}
}
\value{
A gtf object
}
\description{
This function imports a gtf file.
}
\details{
This function imports a gtf file. The features names to be imported are defined in \code{features}, several features are then
provided as vector. A list of available feature can beprinted, by setting \code{print.features=TRUE}.

The \code{skip} option allows to skip a given number of rows, the default is, however, \code{auto}. In that case, all rows that
start with the \code{#} symbol are skipped.
  
In case a set of expression values given in gtf format should be imported and to be merged into a single data table, the feature
that should be used for merging can be provided to the \code{merge.feature} option. In that case the function expects a folder
in \code{file} and it will import all gtfs located in that folder and merges them according to the \code{merge.feature} option.
With the option \code{class.names} a vector of prefixes for the merged features can be provided. If this is kept empty, then the 
filenames of the gtf will be used instead (without gtf extension).
  
By default the function imprts all features in column 9 as string character. However, for common labels (FPKM and TPM) the class
type is set automatically to numeric. Additional numerical feature names can be defined with the \code{num.feature} option.
}
\examples{

 # Define here the location on HDD for the example file
   fpath <- system.file("extdata","example.gtf", package="GenomicTools.fileHandler")
 # Same file, but this time as gzipped version
   fpath.gz <- system.file("extdata","example2.gtf.gz", package="GenomicTools.fileHandler")
   
 # Import the example gtf file  
   importGTF(fpath, level="transcript", features=c("gene_id","FPKM"))
   
 \dontrun{
 # For the current you need to have zcat installed (should be standard on a Linux system)
   importGTF(fpath.gz, level="transcript", features=c("gene_id","FPKM"))
   }
 
}
\author{
Daniel Fischer
}
