% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pop_genomics.R
\name{OneDimSFS}
\alias{OneDimSFS}
\title{OneDimSFS}
\usage{
OneDimSFS(
  vcf_path,
  folded = FALSE,
  batch_size = 10000,
  threads = 1,
  write_log = FALSE,
  logfile = "log.txt",
  exclude_ind = NULL
)
}
\arguments{
\item{vcf_path}{Path to the VCF file.}

\item{folded}{Logical, deciding if folded (TRUE) or unfolded (FALSE) SFS is returned.}

\item{batch_size}{The number of variants to be processed in each batch
(default of 10,000 should be suitable for most use cases).}

\item{threads}{Number of threads to use for parallel processing.}

\item{write_log}{Logical, indicating whether to write progress logs.}

\item{logfile}{Path to the log file where progress will be logged.}

\item{exclude_ind}{Optional vector of individual IDs to exclude from the analysis.
If provided, the function will remove these individuals from the genotype matrix
before applying the custom function. Default is NULL, meaning no individuals are excluded.}
}
\value{
Site frequency spectrum as a named vector
}
\description{
This function calculates a one-dimensional site frequency spectrum from a VCF file. It processes the file in batches for efficient memory usage.
The user can decide between a folded or unfolded spectrum.
}
\examples{
\donttest{vcf_file <- system.file("tests/testthat/sim.vcf.gz", package = "GenoPop")
index_file <- system.file("tests/testthat/sim.vcf.gz.tbi", package = "GenoPop")
sfs <- OneDimSFS(vcf_file, folded = FALSE)}

}
