% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_feature_importances}
\alias{get_feature_importances}
\title{Get Feature Importances}
\usage{
get_feature_importances(pipeline, X_train, pipeline_name, iter)
}
\arguments{
\item{pipeline}{A Scikit-learn pipeline object with a Gradient Boosting Classifier
as the final step.}

\item{X_train}{A DataFrame containing the training data.}

\item{pipeline_name}{Strings (names of the selected_pipelines list) representing pipeline names that were constructed for the feature selection}

\item{iter}{An integer that is indicating current iteration of the train-test split}
}
\value{
A dataframe containing the selected feature names and their importances, ranked by importance, or NULL
if the classifier does not have the appropriate attributes or the feature selector
does not have the 'get_support' or 'support_' method. Each row represents a feature, with columns for
feature names, importances, and ranks.
}
\description{
This function extracts feature importances from a Scikit-learn pipeline
that has a Gradient Boosting Classifier as the final step.
}
