% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GofHMMGen.R
\name{GofHMMGen}
\alias{GofHMMGen}
\title{Goodness-of-fit of univariate hidden Markov model}
\usage{
GofHMMGen(
  y,
  reg,
  family,
  start = 0,
  max_iter = 10000,
  eps = 0.001,
  graph = 0,
  size = 0,
  n_sample = 100,
  n_cores = 1,
  useFest = 1
)
}
\arguments{
\item{y}{observations}

\item{reg}{number of regimes}

\item{family}{distribution name; run the function distributions() for help}

\item{start}{starting parameter for the estimation}

\item{max_iter}{maximum number of iterations of the EM algorithm; suggestion 10000}

\item{eps}{precision (stopping criteria); suggestion 0.0001.}

\item{graph}{1 for a graph, 0 otherwise (default); only for continuous distributions}

\item{size}{additional parameter for some discrete distributions; run the command distributions() for help}

\item{n_sample}{number of bootstrap samples; suggestion 1000}

\item{n_cores}{number of cores to use in the parallel computing}

\item{useFest}{1 (default) to use the first estimated parameters as starting value for the bootstrap, 0 otherwise}
}
\value{
\item{pvalue}{pvalue of the Cramer-von Mises statistic in percent}

\item{theta}{Estimated parameters; (r x p) }

\item{Q}{estimated transition matrix; ; (r x r)}

\item{eta}{(conditional probabilities of being in regime k at time t given observations up to time t; (n x r)}

\item{lambda}{conditional probabilities of being in regime k at time t given all observations; (n x r)}

\item{U}{matrix of Rosenblatt transforms; (n x r)}

\item{cvm}{Cramer-von-Mises statistic for goodness-of-fit}

\item{W}{pseudo-observations that should be uniformly distributed under the null hypothesis}

\item{LL}{log-likelihood}

\item{nu}{stationary distribution}

\item{AIC}{Akaike information criterion}

\item{BIC}{bayesian information criterion}

\item{CAIC}{consistent Akaike information criterion}

\item{AICcorrected}{Akaike information criterion corrected}

\item{HQC}{Hannan-Quinn information criterion}

\item{stats}{Empirical means and standard deviation of each regimes using lambda}

\item{pred_l}{Estimated regime using lambda}

\item{pred_e}{Estimated regime using eta}

\item{runs_l}{Estimated number of runs using lambda}

\item{runs_e}{Estimated number of runs using eta}
}
\description{
This function performs goodness-of-fit test of an univariate hidden Markov model
}
