% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ForecastHMMPdf.R
\name{ForecastHMMPdf}
\alias{ForecastHMMPdf}
\title{Forecasted density function of a univariate HMM at time n+k1, n+k2, ...}
\usage{
ForecastHMMPdf(y, family, theta, Q, eta, k = 1, graph = 0)
}
\arguments{
\item{y}{points at which the pdf function is computed}

\item{family}{distribution name; run the function distributions() for help}

\item{theta}{parameters; (r  x p)}

\item{Q}{probability transition  matrix; (r  x r)}

\item{eta}{vector of the estimated probability of each regime at time n; (1  x r)}

\item{k}{prediction times (may be a vector of integers).}

\item{graph}{(0 or else) produce plots}
}
\value{
\item{pdf}{values of the pdf function}
}
\description{
This function computes the probability forecasted density function of a univariate HMM for multiple horizons, given observations up to time n
}
\examples{
family = "gaussian"

lb = -6
ub = 6

theta = matrix(c(-1.5, 1.7, 1, 1),2,2)
Q = matrix(c(0.8, 0.3, 0.2, 0.7), 2, 2)
eta = c(0.96091218, 0.03908782)


forecastedhmmpdf = ForecastHMMPdf(y=seq(from=lb, to=ub, by=0.1), family=family,
theta=theta, Q=Q, eta=eta, k=c(1,5,10,20), graph=1)


}
