% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/txt.optimize.code.R
\name{txt.optimize.code}
\alias{txt.optimize.code}
\title{Generate optimized code using the Generative AI model based on a prompt}
\usage{
txt.optimize.code(model.parameter, temperature, prompt, goal, language = "R")
}
\arguments{
\item{model.parameter}{A character vector containing the Generative AI service provider,
corresponding model, version, API key, and proxy status.}

\item{temperature}{A numeric value. A higher value results in more creative responses,
while a lower value produces more straightforward text.}

\item{prompt}{A character string representing the query for text generation.}

\item{goal}{A character string representing the goal for code optimization.}

\item{language}{A character string representing the programming language of the code in
the prompt.}
}
\value{
If successful, a character string (optimized code) generated by the Generative AI
model based on the provided query and parameters. If the API response indicates an error,
the function halts execution and provides an error message.
}
\description{
This function establishes a connection to a Generative AI model by providing essential
parameters and generates optimized code based on the prompt.
}
\details{
Providing accurate and valid information for each parameter is crucial
to ensure successful text generation by the Generative AI model. If any of the
provided parameters is incorrect, the function will respond with an error message based
on the information received from the API. Use the function \code{\link{available.models}} to
see all supported Generative AI models.

A complete prompt behind the function is as follows:

Optimize the following \code{language} code.

The goal is: \code{goal}

# Code starts #

\code{prompt}

# Code ends #
}
\examples{
\dontrun{
 # Get available models
 models = available.models()

 # Connect to the model, replace API_KEY with your api key
 google.model = connect.genai("google",
                              models$google$model[1],
                              models$google$version[1],
                              "API_KEY",
                              FALSE)

 # Connect to the model, replace API_KEY with your api key
 openai.model = connect.genai("openai",
                              models$openai$model[1],
                              models$openai$version[1],
                              "API_KEY",
                              FALSE)
 # Generate text
 temperature = 0.9
 prompt = "foo <- function(n) {
             if (n <= 0) {
               return(0)
             } else if (n == 1) {
               return(1)
             } else {
               return(foo(n - 1) + foo(n - 2))
             }
           }"
 goal = "Improve the runtime of the function"
 optimized.code = txt.optimize.code(google.model,
                                    temperature,
                                    prompt,
                                    goal,
                                    language = "R")
 cat(optimized.code)

 optimized.code = txt.optimize.code(openai.model,
                                    temperature,
                                    prompt,
                                    goal,
                                    language = "R")
 cat(optimized.code)
}

}
\seealso{
\href{https://genai.gd.edu.kg/r/documentation/}{GenAI - R Documentation}
}
