\name{scan.gwaa-class}
\docType{class}
\alias{scan.gwaa-class}
\alias{plot, scan.gwaa-method}

\title{Class "scan.gwaa"}
\description{This class contains results of GWA analysis. This is 
an list object, generated by \code{\link{scan.glm}}, \code{\link{scan.haplo}}, \code{\link{ccfast}}, 
\code{\link{qtscore}}, \code{\link{emp.ccfast}}, or \code{\link{emp.qtscore}}.
}
\section{Names}{
  \item{name}{list of names of SNPs tested}
  \item{P1df}{corresponding list of P-values of 1-d.f. (allelic) test for association bestween SNP and trait}
  \item{P2df}{corresponding list of P-values of 2-d.f. (genotypic) test for association bestween SNP and trait}
  \item{medChi1df}{Median Chi-square on 1 d.f.}
  \item{medChi2df}{Median Chi-square on 2 d.f.}
  \item{effB}{Effect of the B allele in allelic test (OR for \code{\link{ccfast}}, difference from the mean for \code{\link{qtscore}} and beta from the \code{\link{scan.glm}})}
  \item{effAB}{Effect of the AB genotype in genotypic test}
  \item{effBB}{Effect of the BB genotype in genotypic test}
  \item{map}{list of map positions of the SNPs}
  \item{chromosome}{list of chromosomes the SNPs belong to}
  \item{formula}{which formula/function call was used to comput P-values}
  \item{family}{family of the link function / nature if the test}
  \item{ids}{list of people used in analysis}
%\describe{}
}
%\section{Extends}{}
\section{Methods}{
  \describe{
    \item{plot}{\code{signature(object = "scan.gwaa")}: 
	Plots summary of GWAA
	 }
  }
}
%\references{}
\author{Yurii Aulchenko}
%\note{}
\seealso{
\code{\link{scan.gwaa-class}},
\code{\link{ccfast}}, 
\code{\link{qtscore}}, 
\code{\link{emp.ccfast}}, 
\code{\link{emp.qtscore}},
\code{\link{plot.scan.gwaa}}
}
\examples{
data(srdta)
sc <- scan.glm("qt3~CRSNP",data=srdta,snps=c(1:10))
class(sc)
sc$P1df
sc$P2df
sc
plot(sc)
}
\keyword{classes}

