% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeDSClass.R
\docType{class}
\name{GeDSboost-class}
\alias{GeDSboost-class}
\alias{GeDSboost-Class}
\title{GeDSboost Class}
\description{
A fitted GeDSboost object returned by the function \code{\link{NGeDSboost}}
inheriting the methods from class \code{"GeDSboost"}. Methods for functions
\code{coef}, \code{knots}, \code{print}, \code{predict},
\code{visualize_boosting}, and \code{bl_imp} are available.
}
\section{Slots}{

\describe{
\item{\code{extcall}}{call to the \code{\link{NGeDSboost}} function.}

\item{\code{formula}}{A formula object representing the model to be fitted.}

\item{\code{args}}{A list containing the arguments passed to the \code{\link{NGeDSboost}}
function. This list includes:
\itemize{
  \item \code{response}: \code{data.frame} containing observations of the
  response variable.
  \item \code{predictors}: \code{data.frame} containing observations of the
  vector of predictor variables included in the model.
  \item \code{base_learners}: description of model's base learners.
  \item \code{family}: the statistical family. The possible options are
  \itemize{
  \item \code{mboost::AdaExp()}
  \item \code{mboost::AUC()}
  \item \code{mboost::Binomial(type = c("adaboost", "glm"),
  link = c("logit", "probit", "cloglog", "cauchit", "log"), ...)}
  \item \code{mboost::Gaussian()}
  \item \code{mboost::Huber(d = NULL)}
  \item \code{mboost::Laplace()}
  \item \code{mboost::Poisson()}
  \item \code{mboost::GammaReg(nuirange = c(0, 100))}
  \item \code{mboost::CoxPH()}
  \item \code{mboost::QuantReg(tau = 0.5, qoffset = 0.5)}
  \item \code{mboost::ExpectReg(tau = 0.5)}
  \item \code{mboost::NBinomial(nuirange = c(0, 100))}
  \item \code{mboost::PropOdds(nuirange = c(-0.5, -1), offrange = c(-5, 5))}
  \item \code{mboost::Weibull(nuirange = c(0, 100))}
  \item \code{mboost::Loglog(nuirange = c(0, 100))}
  \item \code{mboost::Lognormal(nuirange = c(0, 100))}
  \item \code{mboost::Gehan()}
  \item \code{mboost::Hurdle(nuirange = c(0, 100))}
  \item \code{mboost::Multinomial()}
  \item \code{mboost::Cindex(sigma = 0.1, ipcw = 1)}
  \item \code{mboost::RCG(nuirange = c(0, 1), offrange = c(-5, 5))}   
  }   
  \item \code{initial_learner}: if \code{TRUE} a \code{\link{NGeDS}} fit was
  used as initial learner; otherwise, the empirical risk minimizer
  corresponding to the selected \code{family} was employed.
  \item \code{int.knots_init}: if \code{initial_learner = TRUE} the maximum
  number of internal knots set to the \code{\link{NGeDS}} function before the
  initial learner fit.
  \item \code{shrinkage}: shrinkage/step-length/learning rate utilized
  throughout the boosting iterations.
  \item \code{normalize_data}: if \code{TRUE}, then response and predictors
  were standardized before running the FGB algorithm.
  \item \code{X_mean}: mean of the predictor variables (only if
  \code{normalize_data = TRUE}).
  \item \code{X_sd}: standard deviation of the predictors (only if
  \code{normalize_data = TRUE}).
  \item \code{Y_mean}: mean of the response variable (only if
  \code{normalize_data = TRUE}).
  \item \code{Y_sd}: standard deviation of the response variable (only if
  \code{normalize_data = TRUE}).
}}

\item{\code{models}}{A list containing the 'model' generated at each boosting
iteration. Each of these models includes:
\itemize{
 \item \code{best_bl}: fit of the base learner that minimized the residual
 sum of squares (RSS) in fitting the gradient at the \emph{i}-th boosting
 iteration.
  \item \code{Y_hat}: model fitted values at the \emph{i}-th boosting
  iteration.
  \item \code{base_learners}: knots and polynomial coefficients for each of the
  base-learners at the \emph{i}-th boosting iteration.  
}}

\item{\code{final_model}}{A list detailing the final GeDSboost model after the
gradient descent algorithm is run:
\itemize{
\item \code{model_name}: the boosting iteration corresponding to the final
 model.
 \item \code{DEV}: deviance of the final model.
 \item \code{Y_hat}: fitted values.
 \item \code{base_learners}: a list containing, for each base-learner, the
 intervals defined by the piecewise linear fit and its corresponding
 polynomial coefficients. It also includes the knots corresponding to each
 order fit, which result from computing the corresponding averaging knot
 location. See Kaishev et al. (2016) for details. If the number of internal
 knots of the final linear fit is less than $n-1$, the averaging knot location
 is not computed.
 \item \code{Linear.Fit}/\code{Quadratic.Fit}/\code{Cubic.Fit}: final linear,
 quadratic and cubic fits in B-spline form. These include the same elements
 as \code{Linear}, \code{Quadratic} and \code{Cubic} in a \code{\link{GeDS-class}}
 object (see \code{\link{SplineReg}} for details).
 }}

\item{\code{predictions}}{A list containing the predicted values obtained (linear,
quadratic, and cubic).}

\item{\code{internal_knots}}{A list detailing the internal knots obtained for the fits
of different order (linear, quadratic, and cubic).}
}}

\references{
Dimitrova, D. S., Kaishev, V. K., Lattuada, A. and Verrall, R. J.  (2023).
Geometrically designed variable knot splines in generalized (non-)linear
models.
\emph{Applied Mathematics and Computation}, \strong{436}. \cr
DOI: \doi{10.1016/j.amc.2022.127493}

Dimitrova, D. S., Guillen, E. S. and Kaishev, V. K.  (2024).
\pkg{GeDS}: An \proglang{R} Package for Regression, Generalized Additive
Models and Functional Gradient Boosting, based on Geometrically Designed
(GeD) Splines. \emph{Manuscript submitted for publication.}
}
