% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SuppressKDisclosure.R
\name{KDisclosurePrimary}
\alias{KDisclosurePrimary}
\title{Construct primary suppressed difference matrix}
\usage{
KDisclosurePrimary(
  data,
  x,
  crossTable,
  freqVar,
  mc_hierarchies = NULL,
  coalition = 1,
  upper_bound = Inf,
  ...
)
}
\arguments{
\item{data}{a data.frame representing the data set}

\item{x}{ModelMatrix generated by parent function}

\item{crossTable}{crossTable generated by parent function}

\item{freqVar}{name of the frequency variable in \code{data}}

\item{mc_hierarchies}{a hierarchy representing meaningful combinations to be
protected. Default value is \code{NULL}.}

\item{coalition}{numeric vector of length one, representing possible size of an
attacking coalition. This parameter corresponds to the parameter k in the
definition of k-disclosure.}

\item{upper_bound}{numeric value representing minimum count considered safe.
Default set to \code{Inf}}

\item{...}{parameters passed to children functions}
}
\value{
dgCMatrix corresponding to primary suppressed cells
}
\description{
Function for constructing model matrix columns representing primary suppressed
difference cells
}
\author{
Daniel P. Lupp
}
