\name{GWmodel-package}
\alias{GWmodel-package}
\alias{GWmodel}
\docType{package}
\title{
Geographically weighted models
}
\description{
In GWmodel, we introduce techniques from a particular branch of spatial statistics, 
termed geographically weighted (GW) models. GW models suit situations when data are 
not described well by some global model, but where there are spatial regions where 
a suitably localised calibration provides a better description. GWmodel includes functions 
to calibrate: GW summary statistics, GW principal components analysis, GW discriminant analysis 
and various forms of GW regression; some of which are provided in basic and robust (outlier resistant) forms.
}
\details{
\tabular{ll}{
Package: \tab GWmodel\cr
Type: \tab Package\cr
Version: \tab 1.2-2\cr
Date: \tab 2013-12-12\cr
License: \tab GPL (>=2)\cr
LazyLoad: \tab yes\cr
}

}
\author{
Binbin Lu, Paul Harris, Martin Charlton, Chris Brunsdon, Tomoki Nakaya, Isabella Gollini

Maintainer: Binbin Lu <lubinbin220@gmail.com>
}
\note{
Acknowledgement: We gratefully acknowledge support from Science Foundation Ireland 
under the National Development Plan through the award of a Strategic Research Centre 
grant 07-SRC-I1168.
}

\references{
Gollini I, Lu B, Charlton M, Brunsdon C, Harris P (2013) GWmodel: an R Package 
for exploring Spatial Heterogeneity using Geographically Weighted Models. 
\url{http://arxiv.org/abs/1306.0413}

Lu B, Harris P, Charlton M, Brunsdon C (2013) The GWmodel R Package: further 
topics for exploring Spatial Heterogeneity using Geographically Weighted Models.
\url{http://arxiv-web3.library.cornell.edu/abs/1312.2753}
}
\keyword{ package }
