
context("get_GSOD")
# Check that .process_gz works properly and returns a tibble
test_that(
  ".download_files properly works, subsetting for country and
  agroclimatology works and .process_gz returns a tibble",
  {
    skip_on_cran()
    do.call(file.remove, list(list.files(
      tempdir(),
      pattern = ".gz$",
      full.names = TRUE
    )))
    years <- 1982
    agroclimatology <- TRUE
    country <- "RP"
    station <- NULL
    cache_dir <- tempdir()
    ftp_base <-
      "ftp://ftp.ncdc.noaa.gov/pub/data/gsod/%s/"

    load(system.file("extdata", "isd_history.rda", package = "GSODR"))
    stations <- isd_history

    load(system.file("extdata", "country_list.rda",
                     package = "GSODR"))

    GSOD_list <- .download_files(ftp_base,
                                 station,
                                 years,
                                 cache_dir)

    agro_list <- .agroclimatology_list(GSOD_list,
                                       stations,
                                       cache_dir,
                                       years)
    expect_length(agro_list, 7555)

    RP_list <- .subset_country_list(country,
                                    country_list,
                                    GSOD_list,
                                    stations,
                                    cache_dir,
                                    years)
    expect_length(RP_list, 54)

    # Check that .process_gz returns a properly formatted tibble---
    gz_file <- GSOD_list[[10]]
    gz_out <- .process_gz(gz_file, stations)

    expect_length(gz_out, 48)

    expect_is(gz_out, "data.frame")

    expect_is(gz_out$USAF, "character")
    expect_is(gz_out$WBAN, "character")
    expect_is(gz_out$STNID, "character")
    expect_is(gz_out$STN_NAME, "character")
    expect_is(gz_out$CTRY, "character")
    expect_is(gz_out$CALL, "character")
    expect_is(gz_out$STATE, "character")
    expect_is(gz_out$CALL, "character")
    expect_is(gz_out$LAT, "numeric")
    expect_is(gz_out$LON, "numeric")
    expect_is(gz_out$ELEV_M, "numeric")
    expect_is(gz_out$ELEV_M_SRTM_90m, "numeric")
    expect_is(gz_out$BEGIN, "numeric")
    expect_is(gz_out$END, "numeric")
    expect_is(gz_out$YEARMODA, "Date")
    expect_is(gz_out$YEAR, "character")
    expect_is(gz_out$MONTH, "character")
    expect_is(gz_out$DAY, "character")
    expect_is(gz_out$YDAY, "numeric")
    expect_is(gz_out$TEMP, "numeric")
    expect_is(gz_out$TEMP_CNT, "integer")
    expect_is(gz_out$DEWP, "numeric")
    expect_is(gz_out$DEWP_CNT, "integer")
    expect_is(gz_out$SLP, "numeric")
    expect_is(gz_out$SLP_CNT, "integer")
    expect_is(gz_out$STP, "numeric")
    expect_is(gz_out$STP_CNT, "integer")
    expect_is(gz_out$VISIB, "numeric")
    expect_is(gz_out$VISIB_CNT, "integer")
    expect_is(gz_out$WDSP, "numeric")
    expect_is(gz_out$WDSP_CNT, "integer")
    expect_is(gz_out$MXSPD, "numeric")
    expect_is(gz_out$GUST, "numeric")
    expect_is(gz_out$MAX, "numeric")
    expect_is(gz_out$MAX_FLAG, "character")
    expect_is(gz_out$MIN, "numeric")
    expect_is(gz_out$MIN_FLAG, "character")
    expect_is(gz_out$PRCP, "numeric")
    expect_is(gz_out$PRCP_FLAG, "character")
    expect_is(gz_out$SNDP, "numeric")
    expect_is(gz_out$I_FOG, "integer")
    expect_is(gz_out$I_RAIN_DRIZZLE, "integer")
    expect_is(gz_out$I_SNOW_ICE, "integer")
    expect_is(gz_out$I_HAIL, "integer")
    expect_is(gz_out$I_THUNDER, "integer")
    expect_is(gz_out$I_TORNADO_FUNNEL, "integer")
    expect_is(gz_out$EA, "numeric")
    expect_is(gz_out$ES, "numeric")
    expect_is(gz_out$RH, "numeric")
  }
)
