% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regressors.R
\name{phenoRegressor.rrBLUP.SNP}
\alias{phenoRegressor.rrBLUP.SNP}
\title{SNP-BLUP using rrBLUP library}
\usage{
phenoRegressor.rrBLUP.SNP(phenotypes, genotypes, extraCovariates = NULL, ...)
}
\arguments{
\item{phenotypes}{phenotypes, a numeric array (n x 1), missing values are predicted}

\item{genotypes}{SNP genotypes, one row per phenotype (n), one column per marker (m), values in 0/1/2 for
diploids or 0/1/2/...ploidy for polyploids. Can be NULL if \code{covariances} is present.}

\item{extraCovariates}{optional extra covariates set, one row per phenotype (n), one column per covariate (w).
If NULL no extra covariates are considered.}

\item{...}{extra parameters are passed to rrBLUP::mixed.solve}
}
\value{
The function returns a list with the following fields:
\itemize{
  \item \code{predictions} : an array of (k) predicted phenotypes
  \item \code{hyperparams} : named vector with the following keys: Vu, Ve, beta, LL
  \item \code{extradata}   : list with information on trained model, coming from \code{\link[rrBLUP]{mixed.solve}}
}
}
\description{
Implementation of SNP-BLUP using rrBLUP library. Not to be exported.
}
\keyword{internal}
