% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ParetoSetDensity.R
\name{ParetoSetDensity}
\alias{ParetoSetDensity}
\title{Estimation of Pareto set density}
\usage{
ParetoSetDensity(model, lower, upper, CPS = NULL, nsim = 50,
  simpoints = 1000, ...)
}
\arguments{
\item{model}{list of objects of class \code{\link[DiceKriging]{km}}, one for each objective functions,}

\item{lower}{vector of lower bounds for the variables,}

\item{upper}{vector of upper bounds for the variables,}

\item{CPS}{optional matrix containing points from Conditional Pareto Set Simulations
(in the variable space), see details}

\item{nsim}{optional number of conditional simulations to perform if \code{CPS} is not provided,}

\item{simpoints}{(optional) If \code{CPS} is \code{NULL}, either a number of simulation points,
or a matrix where conditional simulations are to be performed. In the first case,
then simulation points are taken as a maximin LHS design using \code{\link[DiceDesign]{lhsDesign}}.}

\item{...}{further arguments to be passed to \code{\link[ks]{kde}}.
In particular, if the input dimension is greater than three,
a matrix \code{eval.points} can be given (else it is taken as the simulation points).}
}
\value{
An object of class \code{\link[ks]{kde}} accounting for the
estimated density of Pareto optimal points.
}
\description{
Estimation of the density of Pareto optimal points in the variable space.
}
\details{
This functino estimates the density of Pareto optimal points in the variable space
given by the surrogate models. Based on conditional simulations of the objectives at simulation points,
Conditional Pareto Set (CPS) simulations are obtained, out of which a density is fitted.

This function relies on the \code{\link[ks]{ks}} package for the kernel density estimation.
}
\examples{
\dontrun{
#---------------------------------------------------------------------------
# Example of estimation of the density of Pareto optimal points
#---------------------------------------------------------------------------
set.seed(42)
n_var <- 2
fname <- P1
lower <- rep(0, n_var)
upper <- rep(1, n_var)

res1 <- easyGParetoptim(fn = fname, lower = lower, upper = upper, budget = 15,
control=list(method = "EHI", inneroptim = "pso", maxit = 20))

estDens <- ParetoSetDensity(res1$history$model, lower = lower, upper = upper)

# graphics
par(mfrow = c(1,2))
plot(estDens, display = "persp", xlab = "X1", ylab = "X2")
plot(estDens, display = "filled.contour2", main = "Estimated density of Pareto optimal point")
points(res1$history$model[[1]]@X[,1], res1$history$model[[2]]@X[,2], col="blue")
points(estDens$x[, 1], estDens$x[, 2], pch = 20, col = rgb(0, 0, 0, 0.15))
par(mfrow = c(1,1))
}
}

