# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @param i_begin, i_end first index in the matrix to consider
#' @param ptr_mat pointer to matrix with dimensions:
#' @param nobj,nr number of columns and rows
#' @noRd
NULL

#' Non dominated indices of a matrix
#' @param mat matrix of objective values, of size n x nobj
#' @return indices of non-dominated points
#' @details Use Kung non-domination sorting
#' @noRd
#' @references
#' Kung, H. T., Luccio, F., & Preparata, F. P. (1975). On finding the maxima of a set of vectors. Journal of the ACM (JACM), 22(4), 469-476.
#' @examples
#' d <- 6
#' n <- 1000
#' test <- matrix(runif(d * n), n)
#' library(emoa)
#' test <- test[order(test[,1]),]
#' indPF_ref <- which(!is_dominated(t(test)))
#' indPF <- nonDomInd(test)
#' all(indPF == indPF_ref)
#'
#' library(microbenchmark)
#' microbenchmark(is_dominated(t(test)), nonDomInd(test))
nonDomInd_cpp <- function(mat) {
    .Call(`_GPGame_nonDomInd_cpp`, mat)
}

#' Determines which elements in a set are dominated by reference points
#' @title Non-dominated points with respect to a reference
#' @param points matrix (one point per row) that are compared to a reference \code{ref} (i.e., not between themselves)
#' @param ref matrix (one point per row) of reference (faster if they are already Pareto optimal)
#' @noRd
#' @examples
#' \dontrun{
#' d <- 6
#' n <- 1000
#' n2 <- 1000
#'
#' test <- matrix(runif(d * n), n)
#' ref <- matrix(runif(d * n), n)
#' indPF <- nonDom(ref)
#'
#' system.time(res <- nonDomSet(test, ref[indPF,,drop = FALSE]))
#'
#' res2 <- rep(NA, n2)
#' library(emoa)
#' t0 <- Sys.time()
#' for(i in 1:n2){
#'   res2[i] <- !is_dominated(t(rbind(test[i,, drop = FALSE], ref[indPF,])))[1]
#' }
#' print(Sys.time() - t0)
#'
#' all(res == res2)
#' }
nonDomSet <- function(points, ref) {
    .Call(`_GPGame_nonDomSet`, points, ref)
}

PSNE_sparseMat <- function(NS, Poffs, expindices) {
    .Call(`_GPGame_PSNE_sparseMat`, NS, Poffs, expindices)
}

PSNE_sparseMat_sorted <- function(NS, Poffs, expindices) {
    .Call(`_GPGame_PSNE_sparseMat_sorted`, NS, Poffs, expindices)
}

getPoffs <- function(isNash, Poffs, nsim, nobj) {
    .Call(`_GPGame_getPoffs`, isNash, Poffs, nsim, nobj)
}

PSNE_sparseMat_cross <- function(NS, Poffs, expindices, combisim, ncross) {
    .Call(`_GPGame_PSNE_sparseMat_cross`, NS, Poffs, expindices, combisim, ncross)
}

getPoffsCross <- function(isNash, Poffs, combisim, nsim) {
    .Call(`_GPGame_getPoffsCross`, isNash, Poffs, combisim, nsim)
}

