% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpfr.functions6.R
\name{plot.gpfr}
\alias{plot.gpfr}
\title{Plot GPFR model for either training or prediction}
\usage{
\method{plot}{gpfr}(
  x,
  type = c("raw", "meanFunction", "fitted", "prediction"),
  ylab = "y",
  xlab = "t",
  ylim = NULL,
  realisations = NULL,
  ...
)
}
\arguments{
\item{x}{Plot GPFR for training or prediction from a given object of 'gpfr'
class.}

\item{type}{Required type of plots. Options are: 'raw',
'meanFunction', 'fitted' and 'prediction'.}

\item{ylab}{Title for the y axis.}

\item{xlab}{Title for the x axis.}

\item{ylim}{Graphical parameter. If NULL (default), it is chosen automatically.}

\item{realisations}{Index vector identifying which training realisations
should be plotted. If NULL (default), all training realisations are plotted. 
For predictions, 'realisations' should be '0' if no training realisation 
is to be plotted.}

\item{...}{Other graphical parameters passed to plot().}
}
\value{
A plot.
}
\description{
Plot GPFR model for either training or prediction
}
\examples{
## See examples in vignette:
# vignette("gpfr", package = "GPFDA")
}
