% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgp.functions.R
\name{mgprPredict}
\alias{mgprPredict}
\title{Prediction of multivariate Gaussian process}
\usage{
mgprPredict(
  train,
  Data.obs = NULL,
  Data.new,
  noiseFreePred = F,
  meanModel = NULL,
  mu = 0
)
}
\arguments{
\item{train}{A 'mgpr' object obtained from 'mgpr' function. 
If NULL, predictions are made based on Data.obs informed by the user.}

\item{Data.obs}{List of observed data. Default to NULL. If NULL,
predictions are made based on the trained data 
(included in the object of class 'mgpr') used for learning.}

\item{Data.new}{List of test input data.}

\item{noiseFreePred}{Logical. If TRUE, predictions will be noise-free.}

\item{meanModel}{Type of mean function applied to all outputs. It can be
\describe{ \item{0}{Zero mean function for each output.} \item{1}{Constant
mean function to be estimated for each output.} \item{'t'}{Linear model for
the mean function of each output.} \item{'avg'}{The average across
replications is used as the mean function of each output. This can only be
used if there are more than two realisations observed at the same input
values.} } Default to 0. If argument 'mu' is specified, then 'meanModel'
will be set to 'userDefined'.}

\item{mu}{Vector of concatenated mean function values defined by the user.
Default to NULL.}
}
\value{
A list containing  \describe{ \item{pred.mean}{Mean of predictions 
for the test set.}
  \item{pred.sd}{Standard deviation of predictions for the test set.}
  \item{noiseFreePred}{Logical. If TRUE, predictions are noise-free.} }
}
\description{
Prediction of multivariate Gaussian process
}
\examples{
## See examples in vignette:
# vignette("mgpr", package = "GPFDA")
}
