% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_rl_deriv_gp.R
\name{compute_rl_deriv_gp}
\alias{compute_rl_deriv_gp}
\title{Detect change-point in full GP}
\usage{
compute_rl_deriv_gp(
  w,
  w_obs,
  y_obs,
  GPS_m,
  hyperparam,
  kernel_fn = function(x) exp(-x),
  kernel_deriv_fn = function(x) -exp(-x)
)
}
\arguments{
\item{w}{A scalar of exposure level of interest.}

\item{w_obs}{A vector of observed exposure levels of all samples.}

\item{y_obs}{A vector of observed outcome values of all samples.}

\item{GPS_m}{A data.frame of GPS vectors.
\itemize{
\item Column 1: GPS
\item Column 2: Prediction of exposure for covariate of each data sample (e_gps_pred).
\item Column 3: Standard deviation of  e_gps (e_gps_std)
}}

\item{hyperparam}{A vector of hyper-parameters in the GP model.}

\item{kernel_fn}{The covariance function.}

\item{kernel_deriv_fn}{The partial derivative of the covariance function.}
}
\value{
A numeric value of the posterior mean of the difference between two one-sided
derivatives.
}
\description{
Calculates the posterior mean of the difference between left- and
right-derivatives at an exposure level for the detection of change points.
}
\examples{
\donttest{
set.seed(847)
data <- generate_synthetic_data(sample_size = 100)
GPS_m <- train_gps(cov_mt = data[,-(1:2)],
                   w_all = data$treat,
                   sl_lib = c("SL.xgboost"),
                   dnorm_log = FALSE)

wi <- 8.6

val <- compute_rl_deriv_gp(w = wi,
                           w_obs = data$treat,
                           y_obs = data$Y,
                           GPS_m = GPS_m,
                           hyperparam = c(1,1,2))
}
}
