% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degreeDistCC.R
\name{Level2LeafNodeCC}
\alias{Level2LeafNodeCC}
\title{GO cellular component (CC) level leaf nodes getter}
\usage{
Level2LeafNodeCC(level, organism = NULL)
}
\arguments{
\item{level}{A numeric value for the GO level}

\item{organism}{An organism of interest from the list of supported organism. If the  argument is NULL the results are
from the general GO-DAG (default).}
}
\value{
All leaf nodes on the level
}
\description{
Derive all the leaf nodes from a GO CC level. The supported organism are "Homo sapiens / Human",
            "Rattus norvegicus / Rat", "Mus musculus / Mouse", "Danio rerio / Zebrafish", "Caenorhabditis elegans / Worm",
            "Arabidopsis thaliana / Cress", "Saccharomyces cerevisiae / Yeast", "Schizosaccharomyces pombe / Fission yeast",
            "Drosophila melanogaster / Fruit fly", "Escherichia coli / E.coli".
}
\examples{
# level 6 leaf nodes for Yeast GO-DAG
Level2LeafNodeCC(6, "Yeast")

# level 4 leaf nodes for Mouse GO-DAG
Level2LeafNodeCC(4, "Mouse")

}
