% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmse_apply_summary.R
\name{gmse_apply_summary}
\alias{gmse_apply_summary}
\title{gmse_apply results summary}
\usage{
gmse_apply_summary(data, output = NULL, include = NULL)
}
\arguments{
\item{data}{The full list as returned by the gmse function.}

\item{output}{An existing gmse_apply_summary output structure to append to.
This should be a matrix with number of columns equal to the length of
`include`. If NULL, a matrix with a single row with just the summary of
given `data` gmse_apply() output is returned.}

\item{include}{A character vector listing which gmse_apply values should be
reported/summarised. Currently allowable values are
"res","obs","culls","scares","castrations","feeds","helps","tend_crops",
"kill_crops","cull_cost","scare_cost", and "yield". Note that for all 
actions and yield, the statistic returned is the sum across users; for 
cull_cost and scare_cost the returned values are the mean costs across 
users. Can be NULL; if so, if `output` is also
NULL, all possible values are returned. If `output` is not NULL, only the
values already present in `ouput` are returned, in the same column order.}
}
\value{
A matrix of gmse_apply values, summarised.
}
\description{
Summarise gmse_apply() output
}
\examples{
\dontrun{
sim_old <- gmse_apply(get_res = "Full", scaring = FALSE, 
land_ownership = TRUE);
gmse_apply_summary(data = sim_old, include = c("res","obs","culls","yield"))
}
}
