% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/full2meta.R, R/meta2full.R
\name{full2meta}
\alias{full2meta}
\alias{meta2full}
\title{Convert between parameter formats}
\usage{
full2meta(theta)

meta2full(par, d)
}
\arguments{
\item{theta}{A list of parameters for the full model. Formatted as described
in \code{\link{rtheta}}.}

\item{par}{A vector of length 4 where \code{par[1]} is the probability of
coming from the first component, \code{par[2]} is the mean value,
\code{par[3]} is the standard deviation, and \code{par[4]} is the
correlation of the reproducible component.}

\item{d}{An integer giving the dimension of the mixture distribution.}
}
\value{
\code{full2meta} returns a numeric vector of length 4 formatted as
  \code{par}.

meta2full returns a formatted list of parameters as described by
  \code{\link{rtheta}}.
}
\description{
These functions converts the parameters between the general Gaussian
mixture (copula) model and the special GMCM.
Most functions of the GMCM packages use the \code{theta}
format described in \code{\link{rtheta}}.
}
\details{
If a \code{theta} is supplied which is not on the form of Li et. al. (2011)
the output is coerced by simply picking the first elements of the first mean
vector and first covariance matrix as mean and standard deviation,
respectively.
}
\examples{
theta <- GMCM:::rtheta(m = 2, d = 2)
print(par <- full2meta(theta))
print(theta.special.case <- meta2full(par, d = 2))
}
\author{
Anders Ellern Bilgrau <anders.ellern.bilgrau@gmail.com>
}
\references{
Li, Q., Brown, J. B. J. B., Huang, H., & Bickel, P. J. (2011).
  Measuring reproducibility of high-throughput experiments. The Annals of
  Applied Statistics, 5(3), 1752-1779. doi:10.1214/11-AOAS466

  Tewari, A., Giering, M., & Raghunathan, A. (2011). Parametric
  Characterization of Multimodal Distributions with Non-gaussian Modes. IEEE
  11th International Conference on Data Mining Workshops, 2011, 286-292.
  doi:10.1109/ICDMW.2011.135
}
\seealso{
\code{\link{rtheta}}
}

