% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dztd.R
\name{d.ztd}
\alias{d.ztd}
\title{Calculate ZTD difference between times}
\usage{
d.ztd(GACOS_ZTD_T1, GACOS_ZTD_T2)
}
\arguments{
\item{GACOS_ZTD_T1}{ZTD time 1}

\item{GACOS_ZTD_T2}{ZTD time 2}
}
\description{
Calculate ZTD difference between times
}
\examples{
library(raster)
library(GInSARCorW)
library(circular)
noDataAsNA<-FALSE
i1m<-system.file("td","20170317.ztd.rsc",package = "GInSARCorW")
i2m<-system.file("td","20170410.ztd.rsc",package = "GInSARCorW")
GACOS_ZTD_T1<-GACOS.Import(i1m,noDataAsNA)
GACOS_ZTD_T2<-GACOS.Import(i2m,noDataAsNA)
d.ztd(GACOS_ZTD_T1,GACOS_ZTD_T2)
}
\author{
Subhadip Datta
}
