% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_GGNet_adjacency_matrix.R
\name{get_GGNet_adjacency_matrix}
\alias{get_GGNet_adjacency_matrix}
\title{obtain an adjacency matrix to make a network graph}
\usage{
get_GGNet_adjacency_matrix(
  ggoutlier_res,
  geo_coord,
  gen_coord,
  mutual = FALSE,
  adjust_p_value = TRUE
)
}
\arguments{
\item{ggoutlier_res}{an output from `ggoutlier`}

\item{geo_coord}{a two-column matrix or data.frame. the first column is longitude and the second one is latitude.}

\item{gen_coord}{a matrix of "coordinates in a genetic space". Users can provide ancestry coefficients or eigenvectors for calculation. If, for example, ancestry coefficients are given, each column corresponds to an ancestral population. Samples are ordered in rows as in `geo_coord`. Users have to provide `pgdM` if `gen_coord` is not given.}

\item{mutual}{logic. If a multi-stage test is used in the outlier identification, some samples could not be a mutual neighbor with its K nearest neighbors. In this case, setting `mutual=TRUE` can force those samples to become mutual neighbors in the output adjacency matrix.}

\item{adjust_p_value}{logic. If `adjust_p_value=TRUE`, p values are adjusted for each nearest neighbor of a given sample.}
}
\value{
a list consisting of four matrices that can be used in building network graphs. The default is `TRUE`
`GeoSP_pvalue` is a matrix describing the strength of edges as p values from the empirical Gamma distribution identified by `detect_outlier_in_GeoSpace`
`GenSP_pvalue` is a matrix describing the strength of edges as p values from the empirical Gamma distribution identified by `detect_outlier_in_GeneticSpace`
}
\description{
`get_GGNet_adjacency_matrix` calculates p-values based on the KNNs and heuristic Gamma distribution obtained in the outlier identification processes. The matrices of p-values are then multiplied with the given genetic similarity matrix to form adjacency matrices.
}
