% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_pcors.R
\name{gen_net}
\alias{gen_net}
\title{Generate True Partial Correlation Matrix}
\usage{
gen_net(p = 20, edge_prob = 0.3, lb = 0.05, ub = 0.3)
}
\arguments{
\item{p}{number of variables (nodes)}

\item{edge_prob}{connectivity}

\item{lb}{lower bound for the partial correlations}

\item{ub}{upper bound for the partial correlations}
}
\value{
A list with the true structure, adjacency matrix, and correlation matrix.
}
\description{
Generate True Partial Correlation Matrix
}
\note{
The function checks for a valid matrix (positive definite),
but sometimes this will
still fail. For example, for larger \code{p}, to have
large partial correlations this requires a sparse GGM
(accomplished by setting \code{edge_prob} to a small value).
}
\examples{

true_net <- gen_net(p = 10)
}
